<?php
session_start();

// Debugging - temporary remove redirects
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Database connection - fixed path
$config_path = __DIR__ . '/../config/database.php';
if (!file_exists($config_path)) {
    die("Config file not found: " . $config_path);
}
require_once $config_path;

// اگر پہلے سے login ہے تو redirect کریں
if (isset($_SESSION['super_admin_id'])) {
    // Temporary debug
    echo "Already logged in. Redirecting to dashboard...";
    header("Location: dashboard.php");
    exit();
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email']);
    $password = $_POST['password'];
    
    // Basic validation
    if (empty($email) || empty($password)) {
        $error = "Please enter email and password";
    } else {
        try {
            $database = new Database();
            $db = $database->getConnection();
            
            // Super admin table سے check کریں
            $query = "SELECT id, name, email, password FROM super_admin WHERE email = ? AND status = 'active'";
            $stmt = $db->prepare($query);
            $stmt->execute([$email]);
            
            if ($stmt->rowCount() == 1) {
                $user = $stmt->fetch(PDO::FETCH_ASSOC);
                
                // Password verify کریں
                if (password_verify($password, $user['password'])) {
                    // Session set کریں
                    $_SESSION['super_admin_id'] = $user['id'];
                    $_SESSION['super_admin_name'] = $user['name'];
                    $_SESSION['super_admin_email'] = $user['email'];
                    $_SESSION['super_admin_role'] = 'super_admin';
                    
                    // Dashboard پر redirect کریں
                    header("Location: dashboard.php");
                    exit();
                }
            }
            
            $error = "Invalid email or password";
        } catch (Exception $e) {
            $error = "Database error: " . $e->getMessage();
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Gym Management - Login</title>
    <link rel="stylesheet" href="./assets/vendors/mdi/css/materialdesignicons.min.css">
    <link rel="stylesheet" href="./assets/vendors/css/vendor.bundle.base.css">
    <link rel="stylesheet" href="./assets/css/style.css">
    <link rel="shortcut icon" href="./assets/images/favicon.png" />
</head>
<body>
    <div class="container-scroller">
        <div class="container-fluid page-body-wrapper full-page-wrapper">
            <div class="content-wrapper d-flex align-items-center auth">
                <div class="row flex-grow">
                    <div class="col-lg-4 mx-auto">
                        <div class="auth-form-light text-left p-5">
                            <div class="brand-logo text-center mb-4">
                                <img src="./assets/images/logo.svg" alt="Logo">
                                <h4 class="mt-2">Gym Management</h4>
                            </div>
                            
                            <h4>Hello! Let's get started</h4>
                            <h6 class="fw-light text-muted mb-4">Sign in to continue</h6>

                            <?php if ($error): ?>
                                <div class="alert alert-danger"><?php echo $error; ?></div>
                            <?php endif; ?>

                            <form method="POST">
                                <div class="form-group">
                                    <input type="email" name="email" class="form-control form-control-lg" 
                                           placeholder="Email" value="<?php echo $_POST['email'] ?? ''; ?>" required>
                                </div>
                                
                                <div class="form-group">
                                    <input type="password" name="password" class="form-control form-control-lg" 
                                           placeholder="Password" required>
                                </div>
                                
                                <div class="mt-3">
                                    <button type="submit" class="btn btn-block btn-primary btn-lg">SIGN IN</button>
                                </div>
                      
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="./assets/vendors/js/vendor.bundle.base.js"></script>
</body>
</html>