<?php
session_start();
if (!isset($_SESSION['super_admin_id'])) {
    header("Location: login.php");
    exit();
}

require_once __DIR__ . '/../config/database.php';

$database = new Database();
$db = $database->getConnection();

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['add_gym'])) {
        // Add new gym
        $name = trim($_POST['name']);
        $owner_name = trim($_POST['owner_name']);
        $email = trim($_POST['email']);
        $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
        $phone = trim($_POST['phone']);
        $address = trim($_POST['address']);
        $registration_number = trim($_POST['registration_number']);
        $status = $_POST['status'];
        
        try {
            $stmt = $db->prepare("INSERT INTO gyms (name, owner_name, email, password, phone, address, registration_number, status, super_admin_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            $stmt->execute([
                $name, $owner_name, $email, $password, $phone, $address, $registration_number, $status, $_SESSION['super_admin_id']
            ]);
            
            $_SESSION['success'] = "Gym added successfully!";
            
            // Redirect to same page with success message
            header("Location: gyms.php");
            exit();
            
        } catch (Exception $e) {
            $_SESSION['error'] = "Error adding gym: " . $e->getMessage();
            header("Location: gyms.php");
            exit();
        }
        
    } elseif (isset($_POST['edit_gym'])) {
        // Update gym
        $gym_id = intval($_POST['gym_id']);
        $name = trim($_POST['name']);
        $owner_name = trim($_POST['owner_name']);
        $email = trim($_POST['email']);
        $phone = trim($_POST['phone']);
        $address = trim($_POST['address']);
        $registration_number = trim($_POST['registration_number']);
        $status = $_POST['status'];
        
        // Check if password is being updated
        $password_update = '';
        $params = [$name, $owner_name, $email, $phone, $address, $registration_number, $status, $gym_id];
        
        if (!empty($_POST['password'])) {
            $password_update = ", password = ?";
            $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
            array_splice($params, 3, 0, [$password]);
        }
        
        try {
            $stmt = $db->prepare("UPDATE gyms SET name = ?, owner_name = ?, email = ?, phone = ?, address = ?, registration_number = ?, status = ? $password_update, updated_at = NOW() WHERE id = ?");
            $stmt->execute($params);
            
            $_SESSION['success'] = "Gym updated successfully!";
        } catch (Exception $e) {
            $_SESSION['error'] = "Error updating gym: " . $e->getMessage();
        }
        
        // Redirect after edit
        header("Location: gyms.php");
        exit();
    }
    
    // یہ EXTRA REDIRECT ہٹا دیں
    // header("Location: gyms.php");
    // exit();
}

// Handle actions via GET
if (isset($_GET['action'])) {
    $action = $_GET['action'];
    $id = intval($_GET['id']);
    
    switch ($action) {
        case 'delete':
            try {
                $stmt = $db->prepare("DELETE FROM gyms WHERE id = ?");
                $stmt->execute([$id]);
                $_SESSION['success'] = "Gym deleted successfully!";
            } catch (Exception $e) {
                $_SESSION['error'] = "Error deleting gym: " . $e->getMessage();
            }
            break;
            
        case 'toggle':
            try {
                $stmt = $db->prepare("UPDATE gyms SET status = IF(status='active', 'inactive', 'active') WHERE id = ?");
                $stmt->execute([$id]);
                $_SESSION['success'] = "Gym status updated!";
            } catch (Exception $e) {
                $_SESSION['error'] = "Error updating gym status: " . $e->getMessage();
            }
            break;
    }
    
    header("Location: gyms.php");
    exit();
}

// باقی code وہی رہے گا..

// Get all gyms with pagination
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$limit = 10;
$offset = ($page - 1) * $limit;

// Search functionality
$search = isset($_GET['search']) ? trim($_GET['search']) : '';
$where = '';
$params = [];

if (!empty($search)) {
    $where = "WHERE (name LIKE ? OR owner_name LIKE ? OR email LIKE ?)";
    $search_term = "%$search%";
    $params = [$search_term, $search_term, $search_term];
}

// Get total count for pagination
$count_stmt = $db->prepare("SELECT COUNT(*) as total FROM gyms $where");
if (!empty($params)) {
    $count_stmt->execute($params);
} else {
    $count_stmt->execute();
}
$total_gyms = $count_stmt->fetch(PDO::FETCH_ASSOC)['total'];
$total_pages = ceil($total_gyms / $limit);

// Get gyms
$stmt = $db->prepare("SELECT * FROM gyms $where ORDER BY created_at DESC LIMIT $limit OFFSET $offset");
if (!empty($params)) {
    $stmt->execute($params);
} else {
    $stmt->execute();
}
$gyms = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Get gym data for edit (if requested via GET)
$edit_gym = null;
if (isset($_GET['edit_id'])) {
    $edit_id = intval($_GET['edit_id']);
    $stmt = $db->prepare("SELECT * FROM gyms WHERE id = ?");
    $stmt->execute([$edit_id]);
    $edit_gym = $stmt->fetch(PDO::FETCH_ASSOC);
}
?>

<?php include 'includes/header.php'; ?>
<?php include 'includes/sidebar.php'; ?>
<?php include 'includes/navbar.php'; ?>

<div class="main-panel">
    <div class="content-wrapper">
        <div class="page-header flex-wrap">
            <div class="header-left">
                <h3 class="page-title">Gym Management</h3>
                <p class="text-muted">Manage all gyms and their login credentials</p>
            </div>
            <div class="header-right d-flex flex-wrap mt-2 mt-sm-0">
                <button type="button" class="btn btn-primary btn-sm pt-2 pb-2" data-bs-toggle="modal" data-bs-target="#addGymModal">
                    <i class="mdi mdi-plus-circle"></i> Add New Gym
                </button>

            </div>
        </div>

        <!-- Success/Error Messages -->
        <?php if (isset($_SESSION['success'])): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?php echo $_SESSION['success']; unset($_SESSION['success']); ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>

        <?php if (isset($_SESSION['error'])): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <?php echo $_SESSION['error']; unset($_SESSION['error']); ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>

        <!-- Search and Filter Section -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <form method="GET" class="row g-3">
                            <div class="col-md-8">
                                <div class="input-group">
                                    <input type="text" name="search" class="form-control" placeholder="Search gyms by name, owner or email..." value="<?php echo htmlspecialchars($search); ?>">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="mdi mdi-magnify"></i> Search
                                    </button>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <?php if (!empty($search)): ?>
                                    <a href="gyms.php" class="btn btn-outline-secondary">
                                        <i class="mdi mdi-close"></i> Clear Search
                                    </a>
                                <?php endif; ?>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Stats Cards -->
        <div class="row mb-4">
            <div class="col-xl-3 col-sm-6 grid-margin stretch-card">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-9">
                                <div class="d-flex align-items-center align-self-start">
                                    <h3 class="mb-0"><?php echo $total_gyms; ?></h3>
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="icon icon-box-primary">
                                    <span class="mdi mdi-dumbbell"></span>
                                </div>
                            </div>
                        </div>
                        <h6 class="text-muted font-weight-normal">Total Gyms</h6>
                    </div>
                </div>
            </div>
            
            <?php
            // Get gym counts by status
            $active_gyms = $db->query("SELECT COUNT(*) as total FROM gyms WHERE status = 'active'")->fetch(PDO::FETCH_ASSOC)['total'];
            $pending_gyms = $db->query("SELECT COUNT(*) as total FROM gyms WHERE status = 'pending'")->fetch(PDO::FETCH_ASSOC)['total'];
            $inactive_gyms = $db->query("SELECT COUNT(*) as total FROM gyms WHERE status = 'inactive'")->fetch(PDO::FETCH_ASSOC)['total'];
            ?>
            
            <div class="col-xl-3 col-sm-6 grid-margin stretch-card">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-9">
                                <div class="d-flex align-items-center align-self-start">
                                    <h3 class="mb-0"><?php echo $active_gyms; ?></h3>
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="icon icon-box-success">
                                    <span class="mdi mdi-check-circle"></span>
                                </div>
                            </div>
                        </div>
                        <h6 class="text-muted font-weight-normal">Active Gyms</h6>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-sm-6 grid-margin stretch-card">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-9">
                                <div class="d-flex align-items-center align-self-start">
                                    <h3 class="mb-0"><?php echo $pending_gyms; ?></h3>
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="icon icon-box-warning">
                                    <span class="mdi mdi-clock"></span>
                                </div>
                            </div>
                        </div>
                        <h6 class="text-muted font-weight-normal">Pending Gyms</h6>
                    </div>
                </div>
            </div>

            <div class="col-xl-3 col-sm-6 grid-margin stretch-card">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-9">
                                <div class="d-flex align-items-center align-self-start">
                                    <h3 class="mb-0"><?php echo $inactive_gyms; ?></h3>
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="icon icon-box-danger">
                                    <span class="mdi mdi-close-circle"></span>
                                </div>
                            </div>
                        </div>
                        <h6 class="text-muted font-weight-normal">Inactive Gyms</h6>
                    </div>
                </div>
            </div>
        </div>

        <!-- Gyms Table -->
        <div class="row">
            <div class="col-12 grid-margin">
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center mb-4">
                            <h4 class="card-title mb-0">All Gyms</h4>
                            <div class="d-flex">
                                <span class="badge bg-light text-dark me-2">Total: <?php echo $total_gyms; ?></span>
                            </div>
                        </div>
                        
                        <div class="table-responsive">
                            <table class="table table-striped table-hover">
                                <thead class="table-dark">
                                    <tr>
                                        <th>#</th>
                                        <th>Gym Name</th>
                                        <th>Owner</th>
                                        <th>Login Credentials</th>
                                        <th>Contact Info</th>
                                        <th>Status</th>
                                        <th>Created Date</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (empty($gyms)): ?>
                                        <tr>
                                            <td colspan="8" class="text-center py-4">
                                                <div class="text-muted">
                                                    <i class="mdi mdi-database-remove mdi-24px mb-2"></i><br>
                                                    No gyms found. 
                                                    <?php if (!empty($search)): ?>
                                                        Try adjusting your search criteria.
                                                    <?php else: ?>
                                                        <a href="#" data-bs-toggle="modal" data-bs-target="#addGymModal">Add your first gym</a>
                                                    <?php endif; ?>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php else: ?>
                                        <?php foreach ($gyms as $index => $gym): 
                                            $status_class = $gym['status'] == 'active' ? 'badge-success' : 
                                                          ($gym['status'] == 'pending' ? 'badge-warning' : 'badge-danger');
                                        ?>
                                        <tr>
                                            <td><?php echo $offset + $index + 1; ?></td>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <div class="bg-light rounded me-2 p-2">
                                                        <i class="mdi mdi-dumbbell text-primary"></i>
                                                    </div>
                                                    <div>
                                                        <strong><?php echo htmlspecialchars($gym['name']); ?></strong>
                                                        <?php if ($gym['registration_number']): ?>
                                                            <br><small class="text-muted">Reg: <?php echo htmlspecialchars($gym['registration_number']); ?></small>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <strong><?php echo htmlspecialchars($gym['owner_name']); ?></strong>
                                            </td>
                                            <td>
                                                <div class="small">
                                                    <div><strong>Email:</strong> <?php echo htmlspecialchars($gym['email']); ?></div>
                                                    <div><strong>Password:</strong> ********</div>
                                                    <div class="text-info">
                                                        <small>
                                                            <i class="mdi mdi-information"></i>
                                                            Use these credentials to login at Gym dashboard
                                                        </small>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="text-muted small">
                                                    <div><i class="mdi mdi-phone me-1"></i> <?php echo htmlspecialchars($gym['phone']); ?></div>
                                                    <div class="text-truncate" style="max-width: 150px;" 
                                                         title="<?php echo htmlspecialchars($gym['address']); ?>">
                                                        <i class="mdi mdi-map-marker me-1"></i> <?php echo htmlspecialchars($gym['address']); ?>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <span class="badge <?php echo $status_class; ?>">
                                                    <?php echo ucfirst($gym['status']); ?>
                                                </span>
                                            </td>
                                            <td>
                                                <?php echo date('M d, Y', strtotime($gym['created_at'])); ?>
                                            </td>
                                            <td>
                                                <div class="btn-group" role="group">
                                                    <a href="gyms.php?edit_id=<?php echo $gym['id']; ?>" class="btn btn-outline-primary btn-sm" title="Edit">
                                                        <i class="mdi mdi-pencil"></i>
                                                    </a>
                                                    <button type="button" class="btn btn-<?php echo $gym['status'] == 'active' ? 'warning' : 'success'; ?> btn-sm"
                                                            onclick="toggleGym(<?php echo $gym['id']; ?>, '<?php echo $gym['status']; ?>', '<?php echo htmlspecialchars($gym['name']); ?>')"
                                                            title="<?php echo $gym['status'] == 'active' ? 'Deactivate' : 'Activate'; ?>">
                                                        <i class="mdi mdi-<?php echo $gym['status'] == 'active' ? 'pause' : 'play'; ?>"></i>
                                                    </button>
                                                    <button type="button" class="btn btn-outline-danger btn-sm"
                                                            onclick="deleteGym(<?php echo $gym['id']; ?>, '<?php echo htmlspecialchars($gym['name']); ?>')"
                                                            title="Delete">
                                                        <i class="mdi mdi-delete"></i>
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>

                        <!-- Pagination -->
                        <?php if ($total_pages > 1): ?>
                        <nav class="mt-4">
                            <ul class="pagination justify-content-center">
                                <li class="page-item <?php echo $page <= 1 ? 'disabled' : ''; ?>">
                                    <a class="page-link" href="gyms.php?page=<?php echo $page - 1; ?><?php echo !empty($search) ? '&search=' . urlencode($search) : ''; ?>">Previous</a>
                                </li>
                                
                                <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                                    <li class="page-item <?php echo $i == $page ? 'active' : ''; ?>">
                                        <a class="page-link" href="gyms.php?page=<?php echo $i; ?><?php echo !empty($search) ? '&search=' . urlencode($search) : ''; ?>"><?php echo $i; ?></a>
                                    </li>
                                <?php endfor; ?>
                                
                                <li class="page-item <?php echo $page >= $total_pages ? 'disabled' : ''; ?>">
                                    <a class="page-link" href="gyms.php?page=<?php echo $page + 1; ?><?php echo !empty($search) ? '&search=' . urlencode($search) : ''; ?>">Next</a>
                                </li>
                            </ul>
                        </nav>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php include 'includes/footer.php'; ?>
</div>

<!-- Add Gym Modal -->
<div class="modal fade" id="addGymModal" tabindex="-1" aria-labelledby="addGymModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="addGymModalLabel">Add New Gym</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="POST">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">Gym Name *</label>
                                <input type="text" name="name" class="form-control" required placeholder="Enter gym name">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">Owner Name *</label>
                                <input type="text" name="owner_name" class="form-control" required placeholder="Enter owner name">
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">Email Address *</label>
                                <input type="email" name="email" class="form-control" required placeholder="Enter email for login">
                                <small class="text-muted">This will be used for admin dashboard login</small>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">Password *</label>
                                <input type="password" name="password" class="form-control" required placeholder="Enter password for login">
                                <small class="text-muted">Default password is "password"</small>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">Phone Number *</label>
                                <input type="text" name="phone" class="form-control" required placeholder="Enter phone number">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">Registration Number</label>
                                <input type="text" name="registration_number" class="form-control" placeholder="Enter registration number">
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="form-label">Address *</label>
                        <textarea name="address" class="form-control" rows="3" required placeholder="Enter complete address"></textarea>
                    </div>

                    <div class="form-group">
                        <label class="form-label">Status *</label>
                        <select name="status" class="form-control" required>
                            <option value="pending">Pending</option>
                            <option value="active" selected>Active</option>
                            <option value="inactive">Inactive</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" name="add_gym" class="btn btn-primary">
                        <i class="mdi mdi-plus-circle"></i> Add Gym
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Gym Modal (Will auto-show if edit_id is set) -->
<div class="modal fade" id="editGymModal" tabindex="-1" aria-labelledby="editGymModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="editGymModalLabel">Edit Gym</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <?php if ($edit_gym): ?>
            <form method="POST">
                <input type="hidden" name="gym_id" value="<?php echo $edit_gym['id']; ?>">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">Gym Name *</label>
                                <input type="text" name="name" class="form-control" required 
                                       value="<?php echo htmlspecialchars($edit_gym['name']); ?>">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">Owner Name *</label>
                                <input type="text" name="owner_name" class="form-control" required 
                                       value="<?php echo htmlspecialchars($edit_gym['owner_name']); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">Email Address *</label>
                                <input type="email" name="email" class="form-control" required 
                                       value="<?php echo htmlspecialchars($edit_gym['email']); ?>">
                                <small class="text-muted">Login email for admin dashboard</small>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">New Password</label>
                                <input type="password" name="password" class="form-control" placeholder="Leave blank to keep current password">
                                <small class="text-muted">Only enter if you want to change the password</small>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">Phone Number *</label>
                                <input type="text" name="phone" class="form-control" required 
                                       value="<?php echo htmlspecialchars($edit_gym['phone']); ?>">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">Registration Number</label>
                                <input type="text" name="registration_number" class="form-control" 
                                       value="<?php echo htmlspecialchars($edit_gym['registration_number']); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="form-label">Address *</label>
                        <textarea name="address" class="form-control" rows="3" required><?php echo htmlspecialchars($edit_gym['address']); ?></textarea>
                    </div>

                    <div class="form-group">
                        <label class="form-label">Status *</label>
                        <select name="status" class="form-control" required>
                            <option value="pending" <?php echo $edit_gym['status'] == 'pending' ? 'selected' : ''; ?>>Pending</option>
                            <option value="active" <?php echo $edit_gym['status'] == 'active' ? 'selected' : ''; ?>>Active</option>
                            <option value="inactive" <?php echo $edit_gym['status'] == 'inactive' ? 'selected' : ''; ?>>Inactive</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <a href="gyms.php" class="btn btn-light">Cancel</a>
                    <button type="submit" name="edit_gym" class="btn btn-primary text-white">
                        <i class="mdi mdi-content-save"></i> Update Gym
                    </button>
                </div>
            </form>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- SweetAlert CDN -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Auto-show edit modal if edit_id is set
    <?php if ($edit_gym): ?>
    const editModal = new bootstrap.Modal(document.getElementById('editGymModal'));
    editModal.show();
    <?php endif; ?>
});

// Delete Gym with SweetAlert
function deleteGym(gymId, gymName) {
    Swal.fire({
        title: 'Are you sure?',
        text: `You are about to delete "${gymName}". This will remove all gym data and login access!`,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Yes, delete it!',
        cancelButtonText: 'Cancel',
        background: '#fff',
        backdrop: 'rgba(0,0,0,0.4)'
    }).then((result) => {
        if (result.isConfirmed) {
            window.location.href = `gyms.php?action=delete&id=${gymId}`;
        }
    });
}

// Toggle Gym Status with SweetAlert
function toggleGym(gymId, currentStatus, gymName) {
    const action = currentStatus === 'active' ? 'deactivate' : 'activate';
    const actionText = currentStatus === 'active' 
        ? 'This gym will no longer be able to access the admin dashboard.' 
        : 'This gym will be able to access the admin dashboard.';
    
    Swal.fire({
        title: `${action.charAt(0).toUpperCase() + action.slice(1)} Gym?`,
        html: `You are about to ${action} <strong>"${gymName}"</strong>.<br>${actionText}`,
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#3085d6',
        confirmButtonText: `Yes, ${action} it!`,
        cancelButtonText: 'Cancel',
        background: '#fff',
        backdrop: 'rgba(0,0,0,0.4)'
    }).then((result) => {
        if (result.isConfirmed) {
            window.location.href = `gyms.php?action=toggle&id=${gymId}`;
        }
    });
}
</script>