<?php
session_start();
require 'config/database.php';

if (isset($_SESSION['gym_id'])) {
    header("Location: index.php");
    exit();
}

$error = '';

if ($_POST) {
    $email = trim($_POST['email']);
    $password = $_POST['password'];
    
    // Basic validation
    if (empty($email) || empty($password)) {
        $error = "Please enter email and password";
    } else {
        $db = (new Database())->getConnection();
        
        $query = "SELECT id, name, email, password, owner_name, status FROM gyms WHERE email = ?";
        $stmt = $db->prepare($query);
        $stmt->execute([$email]);
        
        if ($stmt->rowCount() == 1) {
            $gym = $stmt->fetch(PDO::FETCH_ASSOC); // یہاں $gym variable میں data store کریں
            
            if (password_verify($password, $gym['password'])) {
                // Check if gym is active
                if ($gym['status'] !== 'active') {
                    $error = "Your gym account is not active. Please contact super admin.";
                } else {
                    // Session set کریں - $gym variable استعمال کریں
                    $_SESSION['gym_id'] = $gym['id'];
                    $_SESSION['gym_name'] = $gym['name'];
                    $_SESSION['gym_email'] = $gym['email'];
                    $_SESSION['gym_owner'] = $gym['owner_name'];
                    
                    // Redirect to intended page or index.php
                    if (isset($_SESSION['redirect_url'])) {
                        $redirect_url = $_SESSION['redirect_url'];
                        unset($_SESSION['redirect_url']);
                        header("Location: " . $redirect_url);
                    } else {
                        header("Location: index.php");
                    }
                    exit();
                }
            } else {
                $error = "Invalid email or password";
            }
        } else {
            $error = "Invalid email or password";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Gym Management - Login</title>
    <link rel="stylesheet" href="assets/vendors/mdi/css/materialdesignicons.min.css">
    <link rel="stylesheet" href="assets/vendors/css/vendor.bundle.base.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="shortcut icon" href="assets/images/favicon.png" />
</head>
<body>
    <div class="container-scroller">
        <div class="container-fluid page-body-wrapper full-page-wrapper">
            <div class="content-wrapper d-flex align-items-center auth">
                <div class="row flex-grow">
                    <div class="col-lg-4 mx-auto">
                        <div class="auth-form-light text-left p-5">
                            <div class="brand-logo text-center mb-4">
                                <img src="assets/images/logo.svg" alt="Logo">
                                <h4 class="mt-2">Gym Management</h4>
                            </div>
                            
                            <h4>Hello! Let's get started</h4>
                            <h6 class="fw-light text-muted mb-4">Sign in to continue</h6>

                            <?php if ($error): ?>
                                <div class="alert alert-danger"><?php echo $error; ?></div>
                            <?php endif; ?>

                            <form method="POST">
                                <div class="form-group">
                                    <input type="email" name="email" class="form-control form-control-lg" 
                                           placeholder="Email" value="<?php echo $_POST['email'] ?? ''; ?>" required>
                                </div>
                                
                                <div class="form-group">
                                    <input type="password" name="password" class="form-control form-control-lg" 
                                           placeholder="Password" required>
                                </div>
                                
                                <div class="mt-3">
                                    <button type="submit" class="btn btn-block btn-primary btn-lg">SIGN IN</button>
                                </div>
                                
                                <div class="text-center mt-4">
                                    <!-- Register link ہٹا دیں کیونکہ gyms صرف super admin add کر سکتا ہے -->
                                    <small class="text-muted">Contact super admin to create your gym account</small>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="assets/vendors/js/vendor.bundle.base.js"></script>
</body>
</html>