<?php
session_start();

// Debugging کے لیے
echo "<!-- Index Session: ";
print_r($_SESSION);
echo " -->";

// اگر gym_id نہیں ہے تو login پر redirect کریں
if (!isset($_SESSION['gym_id']) || empty($_SESSION['gym_id'])) {
    header("Location: login.php");
    exit();
}

require 'config/database.php';
$db = (new Database())->getConnection();
$gym_id = $_SESSION['gym_id'];

$gym_stmt = $db->prepare("SELECT name, owner_name FROM gyms WHERE id = ?");
$gym_stmt->execute([$gym_id]);
$current_gym = $gym_stmt->fetch(PDO::FETCH_ASSOC);

// اگر gym موجود نہ ہو تو logout کر دیں
if (!$current_gym) {
    session_destroy();
    header("Location: login.php");
    exit();
}

// Get stats for dashboard - ONLY FOR CURRENT GYM - CORRECTED VERSION
$staff_stmt = $db->prepare("SELECT COUNT(*) as count FROM staff WHERE gym_id = ?");
$staff_stmt->execute([$gym_id]);
$staff_count = $staff_stmt->fetch(PDO::FETCH_ASSOC)['count'];

$active_staff_stmt = $db->prepare("SELECT COUNT(*) as count FROM staff WHERE gym_id = ? AND status = 'active'");
$active_staff_stmt->execute([$gym_id]);
$active_staff = $active_staff_stmt->fetch(PDO::FETCH_ASSOC)['count'];

$members_stmt = $db->prepare("SELECT COUNT(*) as count FROM members WHERE gym_id = ?");
$members_stmt->execute([$gym_id]);
$members_count = $members_stmt->fetch(PDO::FETCH_ASSOC)['count'];

$active_members_stmt = $db->prepare("SELECT COUNT(*) as count FROM members WHERE gym_id = ? AND status = 'active'");
$active_members_stmt->execute([$gym_id]);
$active_members = $active_members_stmt->fetch(PDO::FETCH_ASSOC)['count'];

$expired_members_stmt = $db->prepare("SELECT COUNT(*) as count FROM members WHERE gym_id = ? AND status = 'expired'");
$expired_members_stmt->execute([$gym_id]);
$expired_members = $expired_members_stmt->fetch(PDO::FETCH_ASSOC)['count'];

$plans_stmt = $db->prepare("SELECT COUNT(*) as count FROM membership_plans WHERE gym_id = ? AND status = 'active'");
$plans_stmt->execute([$gym_id]);
$plans_count = $plans_stmt->fetch(PDO::FETCH_ASSOC)['count'];

// Today's registrations - ONLY FOR CURRENT GYM
$today_members_stmt = $db->prepare("SELECT COUNT(*) as count FROM members WHERE gym_id = ? AND DATE(created_at) = CURDATE()");
$today_members_stmt->execute([$gym_id]);
$today_members = $today_members_stmt->fetch(PDO::FETCH_ASSOC)['count'];

$today_payments_stmt = $db->prepare("SELECT COUNT(*) as count FROM payments WHERE gym_id = ? AND DATE(created_at) = CURDATE()");
$today_payments_stmt->execute([$gym_id]);
$today_payments = $today_payments_stmt->fetch(PDO::FETCH_ASSOC)['count'];

// Monthly revenue - ONLY FOR CURRENT GYM
$monthly_revenue_stmt = $db->prepare("SELECT COALESCE(SUM(amount), 0) as total FROM payments WHERE gym_id = ? AND MONTH(payment_date) = MONTH(CURDATE()) AND YEAR(payment_date) = YEAR(CURDATE())");
$monthly_revenue_stmt->execute([$gym_id]);
$monthly_revenue = $monthly_revenue_stmt->fetch(PDO::FETCH_ASSOC)['total'];

// Expiring members (within 7 days) - ONLY FOR CURRENT GYM
$expiring_soon_stmt = $db->prepare("SELECT COUNT(*) as count FROM members WHERE gym_id = ? AND status = 'active' AND expiry_date BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL 7 DAY)");
$expiring_soon_stmt->execute([$gym_id]);
$expiring_soon = $expiring_soon_stmt->fetch(PDO::FETCH_ASSOC)['count'];

// Recent members (last 5) - ONLY FOR CURRENT GYM
$recent_members_query = "SELECT name, member_id, join_date FROM members WHERE gym_id = ? ORDER BY created_at DESC LIMIT 5";
$recent_members_stmt = $db->prepare($recent_members_query);
$recent_members_stmt->execute([$gym_id]);
$recent_members = $recent_members_stmt->fetchAll(PDO::FETCH_ASSOC);

// Recent payments (last 5) - ONLY FOR CURRENT GYM
$recent_payments_query = "SELECT m.name, p.amount, p.payment_date, p.payment_method 
                          FROM payments p 
                          JOIN members m ON p.member_id = m.id 
                          WHERE p.gym_id = ? 
                          ORDER BY p.created_at DESC LIMIT 5";
$recent_payments_stmt = $db->prepare($recent_payments_query);
$recent_payments_stmt->execute([$gym_id]);
$recent_payments = $recent_payments_stmt->fetchAll(PDO::FETCH_ASSOC);

// Get today's attendance stats for staff - ONLY FOR CURRENT GYM
$today_staff_attendance_stmt = $db->prepare("SELECT COUNT(*) as count FROM staff_attendance WHERE gym_id = ? AND attendance_date = CURDATE()");
$today_staff_attendance_stmt->execute([$gym_id]);
$today_staff_attendance = $today_staff_attendance_stmt->fetch(PDO::FETCH_ASSOC)['count'];

$total_staff_stmt = $db->prepare("SELECT COUNT(*) as count FROM staff WHERE gym_id = ? AND status = 'active' AND role != 'receptionist'");
$total_staff_stmt->execute([$gym_id]);
$total_staff = $total_staff_stmt->fetch(PDO::FETCH_ASSOC)['count'];

// Get today's attendance stats for members - ONLY FOR CURRENT GYM
$today_member_attendance_stmt = $db->prepare("SELECT COUNT(*) as count FROM member_attendance WHERE gym_id = ? AND attendance_date = CURDATE()");
$today_member_attendance_stmt->execute([$gym_id]);
$today_member_attendance = $today_member_attendance_stmt->fetch(PDO::FETCH_ASSOC)['count'];

$total_active_members_stmt = $db->prepare("SELECT COUNT(*) as count FROM members WHERE gym_id = ? AND status = 'active'");
$total_active_members_stmt->execute([$gym_id]);
$total_active_members = $total_active_members_stmt->fetch(PDO::FETCH_ASSOC)['count'];
?>

<?php include 'includes/header.php'; ?>
<?php include 'includes/sidebar.php'; ?>
<?php include 'includes/navbar.php'; ?>

<!-- Main Content -->
<div class="main-panel">
    <div class="content-wrapper pb-0">
        <div class="page-header flex-wrap">
            <div class="header-left">
                <h3 class="page-title">Dashboard Overview - <?php echo htmlspecialchars($current_gym['name']); ?></h3>
                <p class="text-muted">Welcome back, <?php echo $_SESSION['gym_owner']; ?>!</p>
            </div>
            <div class="header-right d-flex flex-wrap mt-2 mt-sm-0">
                <div class="d-flex align-items-center">
                    <a href="#">
                        <p class="m-0 pe-3"><i class="mdi mdi-home-outline"></i> Dashboard</p>
                    </a>
                </div>
            </div>
        </div>
<!-- Quick Actions -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title mb-4">Quick Actions</h4>
                <div class="row">

                    <!-- Manage Members -->
                    <div class="col-md-2 col-sm-6 mb-3">
                        <a href="members.php" class="card quick-action-card text-center p-4 text-decoration-none">
                            <div class="icon-box bg-primary text-white mb-3">
                                <i class="mdi mdi-account-multiple"></i>
                            </div>
                            <h6 class="mb-0">Manage Members</h6>
                            <small class="text-muted">View member list</small>
                        </a>
                    </div>

                    <!-- Manage Staff -->
                    <div class="col-md-2 col-sm-6 mb-3">
                        <a href="basic-staff.php" class="card quick-action-card text-center p-4 text-decoration-none">
                            <div class="icon-box bg-info text-white mb-3">
                                <i class="mdi mdi-account-group"></i>
                            </div>
                            <h6 class="mb-0">Manage Staff</h6>
                            <small class="text-muted">View staff list</small>
                        </a>
                    </div>

                    <!-- View Payments -->
                    <div class="col-md-2 col-sm-6 mb-3">
                        <a href="payments.php" class="card quick-action-card text-center p-4 text-decoration-none">
                            <div class="icon-box bg-success text-white mb-3">
                                <i class="mdi mdi-cash"></i>
                            </div>
                            <h6 class="mb-0">View Payments</h6>
                            <small class="text-muted">All transactions</small>
                        </a>
                    </div>

                    <!-- Membership Plans -->
                    <div class="col-md-2 col-sm-6 mb-3">
                        <a href="membership-plans.php" class="card quick-action-card text-center p-4 text-decoration-none">
                            <div class="icon-box bg-warning text-white mb-3">
                                <i class="mdi mdi-card-account-details"></i>
                            </div>
                            <h6 class="mb-0">Plans</h6>
                            <small class="text-muted">Manage pricing</small>
                        </a>
                    </div>

                    <!-- Staff Attendance -->
                    <div class="col-md-2 col-sm-6 mb-3">
                        <a href="reception_attendance.php" class="card quick-action-card text-center p-4 text-decoration-none">
                            <div class="icon-box bg-danger text-white mb-3">
                                <i class="mdi mdi-account-check"></i>
                            </div>
                            <h6 class="mb-0">Staff Attendance</h6>
                            <small class="text-muted">Daily tracking</small>
                        </a>
                    </div>

                    <!-- Member Attendance -->
                    <div class="col-md-2 col-sm-6 mb-3">
                        <a href="member_attendance.php" class="card quick-action-card text-center p-4 text-decoration-none">
                            <div class="icon-box bg-secondary text-white mb-3">
                                <i class="mdi mdi-calendar-check"></i>
                            </div>
                            <h6 class="mb-0">Member Attendance</h6>
                            <small class="text-muted">Check-ins</small>
                        </a>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

        <!-- Second Row Stats -->
        <div class="row">
            <h4>Staff</h4>
            <!-- Total Staff -->
            <div class="col-xl-3 col-sm-6 grid-margin stretch-card">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-9">
                                <div class="d-flex align-items-center align-self-start">
                                    <h3 class="mb-0"><?php echo $staff_count; ?></h3>
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="icon icon-box-info">
                                    <span class="mdi mdi-account-group icon-item"></span>
                                </div>
                            </div>
                        </div>
                        <h6 class="text-muted font-weight-normal">Total Staff</h6>
                    </div>
                </div>
            </div>

            <!-- Active Plans -->
            <div class="col-xl-3 col-sm-6 grid-margin stretch-card">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-9">
                                <div class="d-flex align-items-center align-self-start">
                                    <h3 class="mb-0"><?php echo $plans_count; ?></h3>
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="icon icon-box-success">
                                    <span class="mdi mdi-account-card-details icon-item"></span>
                                </div>
                            </div>
                        </div>
                        <h6 class="text-muted font-weight-normal">Active Plans</h6>
                    </div>
                </div>
            </div>

            <!-- Today's Registrations -->
            <div class="col-xl-3 col-sm-6 grid-margin stretch-card">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-9">
                                <div class="d-flex align-items-center align-self-start">
                                    <h3 class="mb-0"><?php echo $today_members; ?></h3>
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="icon icon-box-primary">
                                    <span class="mdi mdi-account-plus icon-item"></span>
                                </div>
                            </div>
                        </div>
                        <h6 class="text-muted font-weight-normal">Today's Registrations</h6>
                    </div>
                </div>
            </div>

            <!-- Today's Payments -->
            <div class="col-xl-3 col-sm-6 grid-margin stretch-card">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-9">
                                <div class="d-flex align-items-center align-self-start">
                                    <h3 class="mb-0"><?php echo $today_payments; ?></h3>
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="icon icon-box-warning">
                                    <span class="mdi mdi-credit-card-check icon-item"></span>
                                </div>
                            </div>
                        </div>
                        <h6 class="text-muted font-weight-normal">Today's Payments</h6>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <h4>Members</h4>
            <!-- Total Members -->
            <div class="col-xl-3 col-sm-6 grid-margin stretch-card">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-9">
                                <div class="d-flex align-items-center align-self-start">
                                    <h3 class="mb-0"><?php echo $members_count; ?></h3>
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="icon icon-box-primary">
                                    <span class="mdi mdi-account-multiple icon-item"></span>
                                </div>
                            </div>
                        </div>
                        <h6 class="text-muted font-weight-normal">Total Members</h6>
                    </div>
                </div>
            </div>
            
            <!-- Active Members -->
            <div class="col-xl-3 col-sm-6 grid-margin stretch-card">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-9">
                                <div class="d-flex align-items-center align-self-start">
                                    <h3 class="mb-0"><?php echo $active_members; ?></h3>
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="icon icon-box-success">
                                    <span class="mdi mdi-account-check icon-item"></span>
                                </div>
                            </div>
                        </div>
                        <h6 class="text-muted font-weight-normal">Active Members</h6>
                    </div>
                </div>
            </div>

            <!-- Monthly Revenue -->
            <div class="col-xl-3 col-sm-6 grid-margin stretch-card">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-9">
                                <div class="d-flex align-items-center align-self-start">
                                    <h3 class="mb-0">Rs. <?php echo number_format($monthly_revenue); ?></h3>
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="icon icon-box-warning">
                                    <span class="mdi mdi-cash icon-item"></span>
                                </div>
                            </div>
                        </div>
                        <h6 class="text-muted font-weight-normal">Monthly Revenue</h6>
                    </div>
                </div>
            </div>

            <!-- Expiring Soon -->
            <div class="col-xl-3 col-sm-6 grid-margin stretch-card">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-9">
                                <div class="d-flex align-items-center align-self-start">
                                    <h3 class="mb-0"><?php echo $expiring_soon; ?></h3>
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="icon icon-box-danger">
                                    <span class="mdi mdi-alert-circle icon-item"></span>
                                </div>
                            </div>
                        </div>
                        <h6 class="text-muted font-weight-normal">Expiring Soon</h6>
                    </div>
                </div>
            </div>
        </div>

        <!-- Third row status - Staff Attendance -->
        <div class="row">
            <h4>Staff Attendance</h4>
            <div class="col-md-3 mb-4">
                <div class="card card-stats">
                    <div class="card-body">
                        <div class="d-flex justify-content-between">
                            <div>
                                <h4 class="card-title"><?php echo $total_staff; ?></h4>
                                <p class="card-category">Total Staff</p>
                            </div>
                            <div class="icon-big text-center">
                                <i class="mdi mdi-account-multiple text-primary"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card card-stats">
                    <div class="card-body">
                        <div class="d-flex justify-content-between">
                            <div>
                                <h4 class="card-title"><?php echo $today_staff_attendance; ?></h4>
                                <p class="card-category">Staff Marked Today</p>
                            </div>
                            <div class="icon-big text-center">
                                <i class="mdi mdi-calendar-check text-success"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card card-stats">
                    <div class="card-body">
                        <div class="d-flex justify-content-between">
                            <div>
                                <h4 class="card-title"><?php echo date('M d, Y'); ?></h4>
                                <p class="card-category">Today's Date</p>
                            </div>
                            <div class="icon-big text-center">
                                <i class="mdi mdi-calendar text-info"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card card-stats">
                    <div class="card-body">
                        <div class="d-flex justify-content-between">
                            <div>
                                <h4 class="card-title">Reception</h4>
                                <p class="card-category">Marked By</p>
                            </div>
                            <div class="icon-big text-center">
                                <i class="mdi mdi-account-tie text-warning"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Fourth row status - Member Attendance -->
        <div class="row">
            <h4>Member Attendance</h4>
            <div class="col-md-3 mb-4">
                <div class="card card-stats">
                    <div class="card-body">
                        <div class="d-flex justify-content-between">
                            <div>
                                <h4 class="card-title"><?php echo $total_active_members; ?></h4>
                                <p class="card-category">Active Members</p>
                            </div>
                            <div class="icon-big text-center">
                                <i class="mdi mdi-account-multiple text-primary"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card card-stats">
                    <div class="card-body">
                        <div class="d-flex justify-content-between">
                            <div>
                                <h4 class="card-title"><?php echo $today_member_attendance; ?></h4>
                                <p class="card-category">Members Marked Today</p>
                            </div>
                            <div class="icon-big text-center">
                                <i class="mdi mdi-calendar-check text-success"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card card-stats">
                    <div class="card-body">
                        <div class="d-flex justify-content-between">
                            <div>
                                <h4 class="card-title"><?php echo date('M d, Y'); ?></h4>
                                <p class="card-category">Today's Date</p>
                            </div>
                            <div class="icon-big text-center">
                                <i class="mdi mdi-calendar text-info"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card card-stats">
                    <div class="card-body">
                        <div class="d-flex justify-content-between">
                            <div>
                                <h4 class="card-title">Reception</h4>
                                <p class="card-category">Marked By</p>
                            </div>
                            <div class="icon-big text-center">
                                <i class="mdi mdi-account-tie text-warning"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Charts and Tables Row -->
        <div class="row">
            <!-- Recent Members -->
            <div class="col-lg-6 grid-margin stretch-card">
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title">Recent Members</h4>
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Member Name</th>
                                        <th>Member ID</th>
                                        <th>Join Date</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($recent_members as $member): ?>
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <i class="mdi mdi-account me-2 text-primary"></i>
                                                <?php echo htmlspecialchars($member['name']); ?>
                                            </div>
                                        </td>
                                        <td>
<span class="badge badge-light text-dark"><?php echo $member['member_id']; ?></span>
                                        </td>
                                        <td><?php echo date('M d, Y', strtotime($member['join_date'])); ?></td>
                                    </tr>
                                    <?php endforeach; ?>
                                    
                                    <?php if (empty($recent_members)): ?>
                                    <tr>
                                        <td colspan="3" class="text-center text-muted py-3">
                                            No members yet. <a href="members.php">Add your first member</a>
                                        </td>
                                    </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Recent Payments -->
            <div class="col-lg-6 grid-margin stretch-card">
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title">Recent Payments</h4>
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Member Name</th>
                                        <th>Amount</th>
                                        <th>Date</th>
                                        <th>Method</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($recent_payments as $payment): ?>
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <i class="mdi mdi-account me-2 text-success"></i>
                                                <?php echo htmlspecialchars($payment['name']); ?>
                                            </div>
                                        </td>
                                        <td class="text-success fw-bold">
                                            Rs. <?php echo number_format($payment['amount']); ?>
                                        </td>
                                        <td><?php echo date('M d, Y', strtotime($payment['payment_date'])); ?></td>
                                        <td>
                                            <span class="badge badge-info">
                                                <?php echo ucfirst($payment['payment_method']); ?>
                                            </span>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                    
                                    <?php if (empty($recent_payments)): ?>
                                    <tr>
                                        <td colspan="4" class="text-center text-muted py-3">
                                            No payments yet. Payments will appear here.
                                        </td>
                                    </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- System Status Row -->
        <div class="row">
            <div class="col-12 grid-margin">
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title">System Status</h4>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="d-flex align-items-center mb-3">
                                    <div class="icon icon-box-success me-3">
                                        <i class="mdi mdi-server"></i>
                                    </div>
                                    <div>
                                        
                                        <h5 class="mb-0 text-success">Online</h5>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="d-flex align-items-center mb-3">
                                    <div class="icon icon-box-primary me-3">
                                        <i class="mdi mdi-account"></i>
                                    </div>
                                    <div>
                                        <p class="mb-0">Logged in as</p>
                                        <h5 class="mb-0 text-primary"><?php echo $_SESSION['gym_owner']; ?></h5>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="d-flex align-items-center mb-3">
                                    <div class="icon icon-box-info me-3">
                                        <i class="mdi mdi-clock"></i>
                                    </div>
                                    <div>
                                        <p class="mb-0">Gym Name</p>
                                        <h5 class="mb-0 text-info"><?php echo htmlspecialchars($current_gym['name']); ?></h5>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php include 'includes/footer.php'; ?>
</div>
<style>
    .quick-action-card {
    border-radius: 12px;
    transition: 0.3s;
}
.quick-action-card:hover {
    box-shadow: 0 0 15px rgba(0,0,0,0.15);
    transform: translateY(-5px);
}

.icon-box {
    width: 60px;
    height: 60px;
    margin: 0 auto;
    border-radius: 12px;
    display: flex;
    justify-content: center;
    align-items: center;
    font-size: 28px;
}

</style>