<?php
session_start();
if (!isset($_SESSION['gym_id'])) {
    header("Location: login.php");
    exit();
}

require_once 'config/database.php';
$db = (new Database())->getConnection();
$gym_id = $_SESSION['gym_id'];

if (!isset($_GET['staff_id'])) {
    die('Staff ID is required');
}
$staff_id = $_GET['staff_id'];

// Get staff details - CORRECTED QUERY
$staff_query = "SELECT id, name, role FROM staff WHERE id = ? AND gym_id = ?";
$staff_stmt = $db->prepare($staff_query);
$staff_stmt->execute([$staff_id, $gym_id]);
$staff = $staff_stmt->fetch(PDO::FETCH_ASSOC);

if (!$staff) {
    die('Staff member not found or you do not have permission to view this staff');
}

// Get staff attendance history - GYM SPECIFIC (CORRECTED)
$history_query = "SELECT * FROM staff_attendance 
                  WHERE staff_id = ? AND gym_id = ?
                  ORDER BY attendance_date DESC 
                  LIMIT 30";
$history_stmt = $db->prepare($history_query);
$history_stmt->execute([$staff_id, $gym_id]);
$history = $history_stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="staff-history">
    <div class="staff-info mb-3 p-3 bg-light rounded">
        <h6>Staff Information</h6>
        <p><strong>Name:</strong> <?php echo htmlspecialchars($staff['name']); ?></p>
        <p><strong>Role:</strong> <?php echo ucfirst(str_replace('_', ' ', $staff['role'])); ?></p>
    </div>

    <?php if (!empty($history)): ?>
        <div class="table-responsive">
            <table class="table table-sm table-striped">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Check In</th>
                        <th>Check Out</th>
                        <th>Status</th>
                        <th>Notes</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($history as $record): ?>
                    <tr>
                        <td>
                            <?php echo date('M d, Y', strtotime($record['attendance_date'])); ?>
                            <br>
                            <small class="text-muted"><?php echo date('D', strtotime($record['attendance_date'])); ?></small>
                        </td>
                        <td><?php echo $record['check_in'] ?: '--'; ?></td>
                        <td><?php echo $record['check_out'] ?: '--'; ?></td>
                        <td>
                            <span class="badge badge-<?php 
                                echo $record['status'] == 'present' ? 'success' : 
                                    ($record['status'] == 'late' ? 'warning' : 
                                    ($record['status'] == 'half_day' ? 'info' : 'danger')); 
                            ?>">
                                <?php echo ucfirst($record['status']); ?>
                            </span>
                        </td>
                        <td><?php echo $record['notes'] ?: '--'; ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php else: ?>
        <div class="text-center text-muted py-4">
            <i class="mdi mdi-history display-4 d-block mb-2"></i>
            No attendance history found for this staff member.
        </div>
    <?php endif; ?>
</div>