<?php
session_start();
if (!isset($_SESSION['gym_id'])) {
    header("Location: login.php");
    exit();
}

require_once 'config/database.php';
$db = (new Database())->getConnection();
$gym_id = $_SESSION['gym_id'];

if (!isset($_GET['member_id'])) {
    die('Member ID is required');
}

$member_id = $_GET['member_id'];

// Get member details - ONLY FROM CURRENT GYM
$member_query = "SELECT member_id, name, membership_type FROM members WHERE id = ? AND gym_id = ?";
$member_stmt = $db->prepare($member_query);
$member_stmt->execute([$member_id, $gym_id]);
$member = $member_stmt->fetch(PDO::FETCH_ASSOC);

// Get member attendance history - ONLY FROM CURRENT GYM
$history_query = "SELECT * FROM member_attendance 
                  WHERE member_id = ? AND gym_id = ?
                  ORDER BY attendance_date DESC 
                  LIMIT 30";
$history_stmt = $db->prepare($history_query);
$history_stmt->execute([$member_id, $gym_id]);
$history = $history_stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="member-history">
    <div class="member-info mb-3 p-3 bg-light rounded">
        <h6>Member Information</h6>
        <p><strong>Member ID:</strong> <?php echo $member['member_id']; ?></p>
        <p><strong>Name:</strong> <?php echo htmlspecialchars($member['name']); ?></p>
        <p><strong>Membership:</strong> 
            <span class="badge badge-<?php 
                echo $member['membership_type'] == 'vip' ? 'danger' : 
                    ($member['membership_type'] == 'premium' ? 'warning' : 
                    ($member['membership_type'] == 'basic' ? 'info' : 'success')); 
            ?>">
                <?php echo ucfirst($member['membership_type']); ?>
            </span>
        </p>
    </div>

    <?php if (!empty($history)): ?>
        <div class="table-responsive">
            <table class="table table-sm table-striped">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Check In</th>
                        <th>Check Out</th>
                        <th>Status</th>
                        <th>Notes</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($history as $record): ?>
                    <tr>
                        <td>
                            <?php echo date('M d, Y', strtotime($record['attendance_date'])); ?>
                            <br>
                            <small class="text-muted"><?php echo date('D', strtotime($record['attendance_date'])); ?></small>
                        </td>
                        <td><?php echo $record['check_in'] ?: '--'; ?></td>
                        <td><?php echo $record['check_out'] ?: '--'; ?></td>
                        <td>
                            <span class="badge badge-<?php echo $record['status'] == 'present' ? 'success' : 'danger'; ?>">
                                <?php echo ucfirst($record['status']); ?>
                            </span>
                        </td>
                        <td><?php echo $record['notes'] ?: '--'; ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php else: ?>
        <div class="text-center text-muted py-4">
            <i class="mdi mdi-history display-4 d-block mb-2"></i>
            No attendance history found for this member.
        </div>
    <?php endif; ?>
</div>